<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bulk_email_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('bulk_email_campaign_id')->constrained()->cascadeOnDelete();
            $table->string('recipient_email');
            $table->string('status')->default('pending'); // pending, sent, failed
            $table->string('message_id')->nullable();
            $table->text('error_details')->nullable();
            $table->timestamp('sent_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bulk_email_logs');
    }
};
