<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // Change tax_code from ENUM to DECIMAL(5,2) to allow exact rates like 12.00, 18.00
            $table->decimal('tax_code', 5, 2)->default(18.00)->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // Revert back to ENUM if possible (WARNING: Data loss if values don't match enum)
            $table->enum('tax_code', ['0', '5', '12', '18', '28'])->default('18')->change();
        });
    }
};
