<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('order_returns', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->text('reason'); // User's reason for return
            $table->string('status')->default('requested'); // requested, approved, rejected, received, refund_initiated, refunded
            $table->text('admin_note')->nullable(); // For rejection or general notes
            $table->decimal('refund_amount', 10, 2)->nullable();
            $table->decimal('deduction_amount', 10, 2)->default(0);
            $table->string('deduction_reason')->nullable();
            $table->timestamp('refunded_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('order_returns');
    }
};
