<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->text('google_auth_json')->nullable()->after('shiprocket_enabled');
            $table->string('ga4_property_id')->nullable()->after('google_auth_json');
            $table->string('gsc_property_url')->nullable()->after('ga4_property_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->dropColumn(['google_auth_json', 'ga4_property_id', 'gsc_property_url']);
        });
    }
};
