<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->longText('schema_markup')->nullable()->after('meta_keywords'); // Use longText for potentially large JSON
            $table->string('breadcrumbs_title')->nullable()->after('schema_markup');
            $table->string('canonical_url')->nullable()->after('breadcrumbs_title');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn(['schema_markup', 'breadcrumbs_title', 'canonical_url']);
        });
    }
};
