<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('categories', function (Blueprint $table) {
            $table->string('seo_title')->nullable()->after('status');
            $table->text('meta_description')->nullable()->after('seo_title');
            $table->string('breadcrumbs_title')->nullable()->after('meta_description');
            $table->string('canonical_url')->nullable()->after('breadcrumbs_title');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('categories', function (Blueprint $table) {
            $table->dropColumn(['seo_title', 'meta_description', 'breadcrumbs_title', 'canonical_url']);
        });
    }
};
