<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->decimal('reseller_price', 10, 2)->nullable()->after('sp');
        });

        Schema::table('product_variations', function (Blueprint $table) {
            $table->decimal('reseller_price', 10, 2)->nullable()->after('sp');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn('reseller_price');
        });

        Schema::table('product_variations', function (Blueprint $table) {
            $table->dropColumn('reseller_price');
        });
    }
};
