<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->boolean('fcm_enabled')->default(false);
            $table->string('fcm_server_key')->nullable()->comment('Legacy Server Key');
            $table->text('fcm_service_account_json')->nullable()->comment('JSON Content for HTTP v1 auth');
            $table->string('fcm_project_id')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->dropColumn(['fcm_enabled', 'fcm_server_key', 'fcm_service_account_json', 'fcm_project_id']);
        });
    }
};
