<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->boolean('delivery_wallet_enabled')->default(false);
            $table->integer('delivery_wallet_earn_rate')->default(0)->comment('Points earned per 100 rupees of delivery amount');
            $table->integer('delivery_wallet_min_redeem')->default(1000)->comment('Min points required to redeem');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->dropColumn(['delivery_wallet_enabled', 'delivery_wallet_earn_rate', 'delivery_wallet_min_redeem']);
        });
    }
};
