<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $orders = \DB::table('orders')->where('status', '!=', 'pending_payment')->get();
        foreach ($orders as $order) {
            $hasHistory = \DB::table('order_status_histories')->where('order_id', $order->id)->exists();
            if (!$hasHistory) {
                // Add pending at created_at
                \DB::table('order_status_histories')->insert([
                    'order_id' => $order->id,
                    'status' => 'pending',
                    'created_at' => $order->created_at,
                    'updated_at' => $order->created_at,
                ]);

                if ($order->status !== 'pending') {
                    \DB::table('order_status_histories')->insert([
                        'order_id' => $order->id,
                        'status' => $order->status,
                        'created_at' => $order->updated_at,
                        'updated_at' => $order->updated_at,
                    ]);
                }
            }
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // No reverse logic needed for backfill
    }
};
