<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('delivery_agents', function (Blueprint $table) {
            $table->boolean('is_available')->default(true)->after('status');
            $table->decimal('current_latitude', 10, 8)->nullable()->after('is_available');
            $table->decimal('current_longitude', 11, 8)->nullable()->after('current_latitude');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('delivery_agents', function (Blueprint $table) {
            $table->dropColumn(['is_available', 'current_latitude', 'current_longitude']);
        });
    }
};
