<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->boolean('phonepe_enabled')->default(false);
            $table->string('phonepe_merchant_id')->nullable();
            $table->string('phonepe_salt_key')->nullable();
            $table->string('phonepe_salt_index')->default(1);
            $table->string('phonepe_env')->default('UAT');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->dropColumn([
                'phonepe_enabled',
                'phonepe_merchant_id',
                'phonepe_salt_key',
                'phonepe_salt_index',
                'phonepe_env'
            ]);
        });
    }
};
