<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->integer('return_window_days')->default(7)->after('gift_card_expiry_days');
        });

        Schema::table('products', function (Blueprint $table) {
            $table->boolean('is_returnable')->default(true)->after('status');
            $table->integer('return_window_days')->nullable()->after('is_returnable');
            $table->text('return_policy_desc')->nullable()->after('return_window_days');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->dropColumn('return_window_days');
        });

        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn(['is_returnable', 'return_window_days', 'return_policy_desc']);
        });
    }
};
