<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->integer('wallet_exchange_rate')->default(100)->comment('Points equal to 1 currency unit');
            $table->integer('wallet_min_points_redeem')->default(1000)->comment('Min points required to redeem');
            $table->integer('wallet_earn_rate')->default(10)->comment('Points earned per 100 currency units spent');
            $table->boolean('wallet_enabled')->default(true);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            //
        });
    }
};
