<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->decimal('shipping_local_amount', 10, 2)->nullable()->default(0);
            $table->decimal('shipping_national_amount', 10, 2)->nullable()->default(0);
            $table->decimal('shipping_international_amount', 10, 2)->nullable()->default(0);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->dropColumn(['shipping_local_amount', 'shipping_national_amount', 'shipping_international_amount']);
        });
    }
};
