<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            // Razorpay
            $table->boolean('razorpay_enabled')->default(false);
            $table->string('razorpay_key_id')->nullable();
            $table->string('razorpay_key_secret')->nullable();

            // CCAvenue
            $table->boolean('ccavenue_enabled')->default(false);
            $table->string('ccavenue_merchant_id')->nullable();
            $table->string('ccavenue_access_code')->nullable();
            $table->string('ccavenue_encryption_key')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->dropColumn([
                'razorpay_enabled',
                'razorpay_key_id',
                'razorpay_key_secret',
                'ccavenue_enabled',
                'ccavenue_merchant_id',
                'ccavenue_access_code',
                'ccavenue_encryption_key'
            ]);
        });
    }
};
