<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            // PayPal
            $table->string('paypal_email')->nullable();
            $table->string('paypal_link')->nullable();

            // UPI
            $table->string('upi_gpay_id')->nullable();
            $table->string('upi_phonepe_id')->nullable();
            $table->string('upi_bhim_id')->nullable();
            $table->string('upi_cred_id')->nullable();
            $table->string('upi_paytm_id')->nullable();

            // Bank Info
            $table->string('bank_name')->nullable();
            $table->string('bank_account_number')->nullable();
            $table->string('bank_ifsc')->nullable();
            $table->string('bank_beneficiary_name')->nullable();
            $table->string('bank_swift_code')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->dropColumn([
                'paypal_email',
                'paypal_link',
                'upi_gpay_id',
                'upi_phonepe_id',
                'upi_bhim_id',
                'upi_cred_id',
                'upi_paytm_id',
                'bank_name',
                'bank_account_number',
                'bank_ifsc',
                'bank_beneficiary_name',
                'bank_swift_code'
            ]);
        });
    }
};
