<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('agent_vehicles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('delivery_agent_id')->constrained()->onDelete('cascade');
            $table->string('type'); // Bike, Van, etc
            $table->string('vehicle_number');
            $table->string('model')->nullable();
            $table->boolean('is_primary')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('agent_vehicles');
    }
};
