<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('delivery_agents', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            // Personal Details
            $table->string('profile_image')->nullable();
            $table->text('address')->nullable();
            $table->string('phone')->nullable(); // Additional contact if different from user

            // KYC Details
            $table->string('kyc_type')->nullable(); // e.g., Aadhar, Voter ID
            $table->string('kyc_number')->nullable();
            $table->string('kyc_image')->nullable();

            // Vehicle Details
            $table->string('vehicle_type')->nullable(); // e.g., Bike, Van
            $table->string('vehicle_number')->nullable();
            $table->string('vehicle_model')->nullable();

            // License Details
            $table->string('license_number')->nullable();
            $table->string('license_image')->nullable();

            $table->boolean('status')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('delivery_agents');
    }
};
