<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // General Settings Table (Website + Cart)
        Schema::create('general_settings', function (Blueprint $table) {
            $table->id();
            // Website Info
            $table->string('site_logo')->nullable();
            $table->string('phone_sales')->nullable();
            $table->string('phone_support')->nullable();
            $table->string('email_sales')->nullable();
            $table->string('email_support')->nullable();
            $table->text('address_head')->nullable();
            $table->text('address_branch')->nullable();
            $table->json('social_links')->nullable(); // Stores array of {platform, url, icon}

            // Cart Settings
            $table->boolean('cod_enabled')->default(false);
            $table->boolean('free_shipping_enabled')->default(false);
            $table->decimal('free_shipping_amount', 10, 2)->nullable();

            $table->timestamps();
        });

        // Sliders Table
        Schema::create('sliders', function (Blueprint $table) {
            $table->id();
            $table->string('image_path');
            $table->string('alt_text')->nullable();
            $table->string('link')->nullable();
            $table->boolean('status')->default(true);
            $table->integer('sort_order')->default(0);
            $table->timestamps();
        });

        // Promotional Banners Table
        Schema::create('promotional_banners', function (Blueprint $table) {
            $table->id();
            $table->string('image_path');
            $table->string('link')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('promotional_banners');
        Schema::dropIfExists('sliders');
        Schema::dropIfExists('general_settings');
    }
};
