<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->foreignId('category_id')->constrained()->onDelete('cascade');
            $table->foreignId('subcategory_id')->nullable()->constrained('categories')->onDelete('set null');
            $table->string('name');
            $table->string('slug')->unique();
            $table->decimal('mrp', 10, 2);
            $table->decimal('sp', 10, 2);
            $table->enum('tax_code', ['0', '5', '12', '18', '28'])->default('18');
            $table->string('hsn_code')->nullable();

            $table->text('short_description');
            $table->text('long_description')->nullable();
            $table->integer('dispatch_days');
            $table->string('country_origin')->default('India');

            $table->text('warranty_details')->nullable();
            $table->text('guarantee_details')->nullable();

            $table->string('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->text('meta_keywords')->nullable();

            $table->boolean('status')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
