<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__ . '/../routes/web.php',
        api: __DIR__ . '/../routes/api.php',
        commands: __DIR__ . '/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        $middleware->alias([
            'permission' => \App\Http\Middleware\CheckPermission::class,
            'role' => \App\Http\Middleware\CheckRole::class,
            'agent.status' => \App\Http\Middleware\CheckDeliveryAgentStatus::class,
        ]);
        $middleware->validateCsrfTokens(except: [
            'checkout/phonepe/*',
            'checkout/razorpay/*',
        ]);
        $middleware->append(\App\Http\Middleware\UpdateLastSeen::class);
        $middleware->append(\App\Http\Middleware\TrackTrafficSource::class);
        $middleware->append(\App\Http\Middleware\TrackUserActivity::class);
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        $exceptions->report(function (Throwable $e) {
            // Bypass common non-critical errors if needed (e.g., 404s, ValidationException)
            if (
                $e instanceof \Illuminate\Database\Eloquent\ModelNotFoundException ||
                $e instanceof \Symfony\Component\HttpKernel\Exception\NotFoundHttpException ||
                $e instanceof \Illuminate\Validation\ValidationException
            ) {
                return;
            }

            try {
                \App\Models\SystemError::create([
                    'message' => $e->getMessage(),
                    'exception_class' => get_class($e),
                    'url' => request()->fullUrl(),
                    'method' => request()->method(),
                    'stack_trace' => $e->getTraceAsString(),
                    'user_id' => auth()->id(),
                    'ip_address' => request()->ip(),
                    'user_agent' => request()->userAgent(),
                ]);
            } catch (\Throwable $th) {
                // If database logging fails, we fall back to default Laravel logging
                \Illuminate\Support\Facades\Log::error('Failed to log system error: ' . $th->getMessage());
            }
        });
    })->create();
