<?php
use App\Models\Order;
use App\Models\OrderStatusHistory;

$orders = Order::all();
foreach ($orders as $order) {
    if ($order->statusHistories()->count() === 0) {
        if ($order->status !== 'pending_payment') {
            // Reconstruct history based on current status
            // For simplicity, we'll just add the current status at its updated_at
            // and maybe a "pending" entry at its created_at if it's past pending.

            if ($order->status === 'pending') {
                $order->statusHistories()->create(['status' => 'pending', 'created_at' => $order->created_at, 'updated_at' => $order->created_at]);
            } else {
                // Add pending at created_at
                $order->statusHistories()->create(['status' => 'pending', 'created_at' => $order->created_at, 'updated_at' => $order->created_at]);
                // Add current status at updated_at
                $order->statusHistories()->create(['status' => $order->status, 'created_at' => $order->updated_at, 'updated_at' => $order->updated_at]);
            }
            echo "Backfilled Order #{$order->order_number}\n";
        }
    }
}
