<?php

namespace App\Services;

use App\Models\EmailTemplate;
use App\Models\GeneralSetting;
use App\Mail\DynamicTemplateMail;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;

class OrderMailService
{
    public static function sendNotification($order, $category, $role)
    {
        try {
            $template = EmailTemplate::where('category', $category)
                ->where('target_role', $role)
                ->where('is_active', true)
                ->first();

            if (!$template) {
                Log::warning("Email template not found for Category: {$category}, Role: {$role}");
                return;
            }

            $settings = GeneralSetting::first();
            $data = [
                'order_number' => $order->order_number,
                'customer_name' => $order->user ? $order->user->name : $order->name,
                'delivery_address' => $order->shippingAddress ? $order->shippingAddress->address_line1 . ', ' . $order->shippingAddress->city : 'N/A',
                'order_total' => $order->total,
                'order_url' => route('user.orders.show', $order->id),
                'admin_order_url' => route('admin.orders.show', $order->id),
                'delivery_agent_name' => $order->deliveryAgent && $order->deliveryAgent->user ? $order->deliveryAgent->user->name : 'N/A',
                'order_items_summary' => self::getItemsSummary($order),
                'cancellation_reason' => $order->cancellation_reason ?? 'N/A',
                'cancelled_by' => 'User/Admin',
                'refund_status' => $order->payment_status === 'paid' ? 'Required' : 'Not Required',
            ];

            $recipient = '';
            if ($role === 'Admin') {
                $recipient = $settings->email_sales ?: config('mail.from.address');
            } else {
                $recipient = $order->email;
            }

            if ($recipient) {
                Mail::to($recipient)->send(new DynamicTemplateMail($template, $data));
            }
        } catch (\Exception $e) {
            Log::error("Failed to send order email: " . $e->getMessage());
        }
    }

    private static function getItemsSummary($order)
    {
        $summary = "";
        foreach ($order->items as $item) {
            $summary .= "{$item->quantity} x " . ($item->product ? $item->product->name : 'Product') . "\n";
        }
        return nl2br($summary);
    }
}
