<?php

namespace App\Services;

use App\Models\GeneralSetting;
use Illuminate\Support\Facades\Config;

class MailConfigService
{
    public static function setDynamicConfig()
    {
        $settings = GeneralSetting::first();
        if (!$settings || !$settings->mail_mailer) {
            // Using .env configuration
            return;
        }

        $mailer = $settings->mail_mailer;

        Config::set('mail.default', $mailer);

        if ($mailer === 'smtp') {
            Config::set('mail.mailers.smtp.host', $settings->mail_host);
            Config::set('mail.mailers.smtp.port', $settings->mail_port);
            Config::set('mail.mailers.smtp.username', $settings->mail_username);
            Config::set('mail.mailers.smtp.password', $settings->mail_password);
            Config::set('mail.mailers.smtp.encryption', $settings->mail_encryption);
        } elseif ($mailer === 'mailgun') {
            Config::set('services.mailgun.domain', $settings->mailgun_domain);
            Config::set('services.mailgun.secret', $settings->mailgun_secret);
            Config::set('services.mailgun.endpoint', $settings->mailgun_endpoint ?: 'api.mailgun.net');
        }

        Config::set('mail.from.address', $settings->mail_from_address);
        Config::set('mail.from.name', $settings->mail_from_name);
    }
}
