<?php

namespace App\Services;

use App\Models\CustomOffer;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Request;

class CustomOfferService
{
    public function getOffersForCurrentPage()
    {
        // 1. Identify Current Page "Slug"
        $currentSlug = $this->getCurrentPageSlug();
        \Illuminate\Support\Facades\Log::info("CustomOfferService: Current Slug: " . ($currentSlug ?? 'NULL'));

        if (!$currentSlug) {
            return collect([]);
        }

        // 2. Fetch Active Offers
        $offers = CustomOffer::where('status', true)
            ->with(['layout', 'items'])
            ->get();
        
        \Illuminate\Support\Facades\Log::info("CustomOfferService: Total Active Offers: " . $offers->count());

        // 3. Filter Matches
        $filtered = $offers->filter(function ($offer) use ($currentSlug) {
            $pages = $offer->placement_pages ?? [];
            return is_array($pages) && in_array($currentSlug, $pages);
        });

        \Illuminate\Support\Facades\Log::info("CustomOfferService: Filtered Offers: " . $filtered->count());

        return $filtered;
    }

    private function getCurrentPageSlug()
    {
        $route = Route::current();
        if (!$route) return null;

        $name = $route->getName();
        $params = $route->parameters();

        // 1. Static Pages
        if ($name === 'home') return 'home';
        if ($name === 'shop.index') return 'shop';
        
        // 2. CMS Pages
        if ($name === 'pages.show') {
            return $params['slug'] ?? null;
        }

        // 3. Collections / Categories
        if ($name === 'shop.category') {
            // This is a top-level category page? 
            // In our Placement options, we save 'collections/parent/child' usually.
            // But if we want to target top level categories, we might need to adjust logic.
            // For now, let's assume we match exact slugs if possible.
            // OR if the user selected a "Category" page in the placement selector.
            return $params['slug'] ?? null; 
        }

        if ($name === 'shop.subcategory') {
            // format: collections/{category}/{subcategory}
            $cat = $params['category'] ?? '';
            $sub = $params['subcategory'] ?? '';
            return "collections/{$cat}/{$sub}";
        }
        
        // Add more logic as needed for other page types

        return null;
    }
}
