<?php

namespace App\Services;

use App\Models\UserActivity;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;

class ActivityTracker
{
    public static function log($eventType, $metaData = [])
    {
        // Ignore admin or bots if needed, for now track everyone
        if (Request::segment(1) === 'admin') {
            return;
        }

        $sessionId = Session::getId();
        if (!$sessionId) {
            Session::start();
            $sessionId = Session::getId();
        }

        UserActivity::create([
            'session_id' => $sessionId,
            'user_id' => Auth::id(),
            'event_type' => $eventType,
            'url' => Request::fullUrl(),
            'ip_address' => Request::ip(),
            'meta_data' => $metaData,
        ]);
    }
}
