<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

use App\Notifications\Channels\FCMChannel;

class DeliveryAgentNotification extends Notification
{
    use Queueable;

    protected $message;
    protected $title;

    /**
     * Create a new notification instance.
     */
    public function __construct($message, $title = 'Notification')
    {
        $this->message = $message;
        $this->title = $title;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database', FCMChannel::class];
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'title' => $this->title,
            'message' => $this->message,
            'created_at' => now(),
        ];
    }

    public function toFcm($notifiable)
    {
        return [
            'title' => $this->title,
            'body' => $this->message,
            'data' => [
                'type' => 'delivery_notification'
            ]
        ];
    }
}
