<?php

namespace App\Notifications\Channels;

use Illuminate\Notifications\Notification;
use App\Services\FCMService;
use Illuminate\Support\Facades\Storage;

class FCMChannel
{
    protected $fcmService;

    public function __construct(FCMService $fcmService)
    {
        $this->fcmService = $fcmService;
    }

    public function send($notifiable, Notification $notification)
    {
        if (!method_exists($notification, 'toFcm')) {
            return;
        }

        $message = $notification->toFcm($notifiable);

        // Collect all tokens
        $tokens = [];

        // 1. New file-based tokens (Multi-device support without DB migration)
        try {
            $path = "fcm_tokens/{$notifiable->id}.json";
            if (Storage::exists($path)) {
                $content = Storage::get($path);
                $tokens = json_decode($content, true) ?? [];
            }
        } catch (\Exception $e) {
            // Ignore file read errors
        }

        // 2. Legacy token column (if not in file or if file fails)
        if ($notifiable->fcm_token && !in_array($notifiable->fcm_token, $tokens)) {
            $tokens[] = $notifiable->fcm_token;
        }

        $tokens = array_unique($tokens);

        if (empty($tokens)) {
            return;
        }

        // Send to each token
        foreach ($tokens as $token) {
            try {
                $this->fcmService->sendNotification(
                    $token,
                    $message['title'] ?? 'Notification',
                    $message['body'] ?? '',
                    $message['data'] ?? []
                );
            } catch (\Exception $e) {
                // Continue sending to others even if one fails
            }
        }
    }
}
