<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

use App\Notifications\Channels\FCMChannel;

class AdminOrderNotification extends Notification
{
    use Queueable;

    protected $order;

    /**
     * Create a new notification instance.
     */
    public function __construct($order)
    {
        $this->order = $order;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database', FCMChannel::class];
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'title' => 'New Order Placed',
            'message' => "Order #{$this->order->order_number} has been placed.",
            'order_id' => $this->order->id,
            'created_at' => now(),
        ];
    }

    public function toFcm($notifiable)
    {
        return [
            'title' => 'New Order Alert',
            'body' => "Order #{$this->order->order_number} has been placed.",
            'data' => [
                'order_id' => $this->order->id,
                'type' => 'new_order'
            ]
        ];
    }
}
