<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Slider extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'status' => 'boolean',
    ];

    // Remove $appends and use accessor for 'image_path' direclty
    public function getImagePathAttribute($value)
    {
        if (!$value) {
            return asset('images/slider-placeholder.png');
        }

        if (filter_var($value, FILTER_VALIDATE_URL)) {
            return $value;
        }

        // Add storage prefix if missing and path is relative
        if (!str_starts_with($value, 'storage/') && !str_starts_with($value, '/storage/')) {
            $value = 'storage/' . ltrim($value, '/');
        }

        return asset(ltrim($value, '/'));
    }
}
