<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductVariation extends Model
{
    protected $fillable = [
        'product_id',
        'mrp',
        'sp',
        'reseller_price',
        'stock',
        'sku',
        'image_path',
        'thumbnail_path',
        'sort_order',
    ];

    protected $appends = [];

    public function getImagePathAttribute($value)
    {
        if (!$value)
            return null;
        if (filter_var($value, FILTER_VALIDATE_URL))
            return $value;

        // Add storage prefix if missing and path is relative
        if (!str_starts_with($value, 'storage/') && !str_starts_with($value, '/storage/')) {
            $value = 'storage/' . ltrim($value, '/');
        }

        return asset(ltrim($value, '/'));
    }

    public function getThumbnailPathAttribute($value)
    {
        if (!$value)
            return null;
        if (filter_var($value, FILTER_VALIDATE_URL))
            return $value;
        return asset(ltrim($value, '/'));
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function options()
    {
        return $this->hasMany(ProductVariationOption::class);
    }
}
