<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductImage extends Model
{
    use HasFactory;

    protected $fillable = [
        'product_id',
        'image_path',
        'thumbnail_path',
        'alt_text',
        'sort_order',
    ];

    protected $appends = [];

    public function getImagePathAttribute($value)
    {
        if (!$value) {
            return asset('images/placeholder.png');
        }

        if (filter_var($value, FILTER_VALIDATE_URL)) {
            return $value;
        }

        // Add storage prefix if missing and path is relative
        if (!str_starts_with($value, 'storage/') && !str_starts_with($value, '/storage/')) {
            $value = 'storage/' . ltrim($value, '/');
        }

        return asset(ltrim($value, '/'));
    }

    public function getThumbnailPathAttribute($value)
    {
        if (!$value)
            return null; // Or placeholder
        if (filter_var($value, FILTER_VALIDATE_URL))
            return $value;
        return asset(ltrim($value, '/'));
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
