<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GeneralSetting extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'social_links' => 'array',
        'cod_enabled' => 'boolean',
        'free_shipping_enabled' => 'boolean',
        'razorpay_enabled' => 'boolean',
        'ccavenue_enabled' => 'boolean',
        'phonepe_enabled' => 'boolean',
        'cancellation_rules' => 'array',
        'refund_rules' => 'array',
        'gift_card_enabled' => 'boolean',
        'gift_card_expiry_days' => 'integer',
        'return_window_days' => 'integer',
        'fcm_enabled' => 'boolean',
        'shiprocket_enabled' => 'boolean',
    ];
    public function currentStore()
    {
        return $this->belongsTo(Store::class, 'current_store_id');
    }
}
