<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Discount extends Model
{
    protected $fillable = [
        'name',
        'type',
        'value',
        'buy_x',
        'get_y',
        'valid_from',
        'valid_until',
        'is_active',
    ];

    protected $casts = [
        'valid_from' => 'datetime',
        'valid_until' => 'datetime',
        'is_active' => 'boolean',
    ];

    public function products()
    {
        return $this->morphedByMany(Product::class, 'discountable');
    }

    public function categories()
    {
        return $this->morphedByMany(Category::class, 'discountable');
    }
}
