<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory;

    protected $fillable = [
        'parent_id',
        'name',
        'slug',
        'image_url',
        'status',
        'schema_markup',
        'seo_title',
        'meta_description',
        'breadcrumbs_title',
        'canonical_url',
        'is_nofollow',
    ];

    public function getImageUrlAttribute($value)
    {
        if (!$value) {
            return asset('images/category-placeholder.png');
        }

        if (filter_var($value, FILTER_VALIDATE_URL)) {
            return $value;
        }

        return asset(ltrim($value, '/'));
    }

    public function parent()
    {
        return $this->belongsTo(Category::class, 'parent_id');
    }

    public function children()
    {
        return $this->hasMany(Category::class, 'parent_id');
    }

    public function discounts()
    {
        return $this->morphToMany(Discount::class, 'discountable');
    }

    public function products()
    {
        return $this->hasMany(Product::class);
    }

    public function subProducts()
    {
        return $this->hasMany(Product::class, 'subcategory_id');
    }
}
