<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use App\Services\MailConfigService;

class DynamicTemplateMail extends Mailable
{
    use Queueable, SerializesModels;

    public $template;
    public $data;

    public function __construct($template, $data)
    {
        $this->template = $template;
        $this->data = $data;
        MailConfigService::setDynamicConfig();
    }

    public function build()
    {
        MailConfigService::setDynamicConfig();

        $content = $this->template->content;
        $subject = $this->template->subject;

        foreach ($this->data as $key => $value) {
            $content = str_replace('{{ ' . $key . ' }}', $value, $content);
            $subject = str_replace('{{ ' . $key . ' }}', $value, $subject);
        }

        return $this->subject($subject)
            ->html($content);
    }
}
