<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

class UpdateLastSeen
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (Auth::check()) {
            $user = Auth::user();
            // Update only if more than 2 minutes have passed since last update to reduce DB writes
            $lastSeen = $user->last_seen_at ? Carbon::parse($user->last_seen_at) : null;

            if (!$lastSeen || $lastSeen->diffInMinutes(now()) > 2) {
                $user->update(['last_seen_at' => now()]);
            }
        }
        return $next($request);
    }
}
