<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Services\ActivityTracker;

class TrackUserActivity
{
    public function handle(Request $request, Closure $next)
    {
        // Ignore AJAX unless critical
        // Ignore assets, admin routes
        if ($request->ajax() || $request->is('admin/*') || $request->is('api/*') || $request->is('livewire/*')) {
            return $next($request);
        }

        // Only track GET requests for page views
        if ($request->isMethod('get')) {
            $eventType = 'page_view';

            // Refine event based on route
            if ($request->routeIs('shop.product')) {
                $eventType = 'view_product';
                // Extract slug or product info if possible?
                // For now generic view_product is fine
            } elseif ($request->routeIs('checkout.index')) {
                $eventType = 'initiate_checkout';
            } elseif ($request->routeIs('cart.index')) {
                $eventType = 'view_cart';
            } elseif ($request->routeIs('checkout.success')) {
                $eventType = 'purchase_success';
            }

            ActivityTracker::log($eventType);
        }

        return $next($request);
    }
}
