<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class CheckRole
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, string $role): Response
    {
        if (!Auth::check()) {
            return redirect('login');
        }

        $user = Auth::user();

        // Support multiple roles separated by pipe |
        $roles = explode('|', $role);

        foreach ($roles as $roleName) {
            if ($user->hasRole($roleName)) {
                return $next($request);
            }
        }

        abort(403, 'Unauthorized action.');
    }
}
