<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class CheckPermission
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, string $permission): Response
    {
        if (!Auth::check()) {
            return redirect()->route('admin.login');
        }

        $user = Auth::user();

        // Optional: Super Admin bypass (if you have a specific role name for it, e.g., 'Super Admin')
        // Super Admin bypass
        if ($user->hasRole('Admin') || $user->hasRole('Super Admin')) {
            return $next($request);
        }

        if (!$user->hasPermission($permission)) {
            // Check if it's an AJAX request to return JSON
            if ($request->expectsJson()) {
                return response()->json(['message' => 'Unauthorized action.'], 403);
            }
            abort(403, 'User does not have the right permissions.');
        }

        return $next($request);
    }
}
