<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckDeliveryAgentStatus
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = $request->user();

        if (!$user) {
            return $next($request);
        }

        if (!$user->is_active) {
            if ($request->expectsJson()) {
                return response()->json(['message' => 'Account is inactive.'], 403);
            }
            return redirect()->route('login')->with('error', 'Account is inactive.');
        }

        if ($user->hasRole('delivery_agent')) {
            $agent = \App\Models\DeliveryAgent::where('user_id', $user->id)->first();
            if (!$agent || !$agent->status) {
                if ($request->expectsJson()) {
                    // Revoke tokens if they are logged in but marked inactive
                    $user->tokens()->delete();
                    return response()->json(['message' => 'Delivery Agent profile is inactive.'], 403);
                }
                \Illuminate\Support\Facades\Auth::logout();
                return redirect()->route('login')->with('error', 'Delivery Agent profile is inactive.');
            }
        }

        return $next($request);
    }
}
