<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\VideoConsultationBooking;

class VideoConsultationController extends Controller
{
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'phone' => 'required|string|max:20',
            'date' => 'required|date|after_or_equal:today',
            'time_slot' => 'required|string',
            'message' => 'nullable|string',
            'interested_products' => 'nullable|array',
            'interested_products.*' => 'string'
        ]);

        $booking = VideoConsultationBooking::create($validated);

        // Send Confirmation Email
        try {
            $template = \App\Models\EmailTemplate::where('name', 'Video Consultation Confirmation')->first();
            if ($template && $template->is_active) {
                $settings = \App\Models\GeneralSetting::first();
                $data = [
                    'name' => $booking->name,
                    'date' => $booking->date->format('d M, Y'),
                    'time_slot' => $booking->time_slot,
                    'year' => date('Y'),
                    'app_url' => config('app.url'),
                    'logo_url' => $settings && $settings->site_logo ? asset('storage/' . $settings->site_logo) : asset('images/logo.png'),
                ];
                \Illuminate\Support\Facades\Mail::to($booking->email)->send(new \App\Mail\DynamicTemplateMail($template, $data));
            }
        } catch (\Exception $e) {
            // Log error or ignore to not break the user flow
            \Illuminate\Support\Facades\Log::error('Video Consultation Email Error: ' . $e->getMessage());
        }

        return redirect()->back()->with('success', 'Your consultation has been booked successfully! We will contact you shortly.');
    }
}
