<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Subscriber;

class SubscriberController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'email' => 'required|email|unique:subscribers,email'
        ]);

        Subscriber::create([
            'email' => $request->email,
            'is_active' => true
        ]);

        if ($request->wantsJson() || $request->ajax()) {
            return response()->json(['message' => 'Thank you for subscribing!']);
        }

        return back()->with('success', 'Thank you for subscribing!');
    }
}
