<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ResellerApplication;
use Illuminate\Support\Facades\Auth;

class ResellerController extends Controller
{
    public function create()
    {
        return view('shop.reseller.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'phone' => 'required|string|max:20',
            'address' => 'required|string',
            'city' => 'required|string|max:100',
            'state' => 'required|string|max:100',
            'postal_code' => 'required|string|max:20',
            'company_name' => 'required|string|max:255',
            'company_website' => 'nullable|url|max:255',
            'gst_number' => 'required|string|max:50',
        ]);

        $application = new ResellerApplication($validated);

        if (Auth::check()) {
            $application->user_id = Auth::id();
        }

        $application->status = 'pending';
        $application->save();

        return redirect()->route('reseller.success');
    }

    public function success()
    {
        return view('shop.reseller.success');
    }
}
