<?php

namespace App\Http\Controllers\Reseller;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Reseller;
use Illuminate\Support\Facades\Storage;

class DashboardController extends Controller
{
    public function index()
    {
        return view('reseller.dashboard');
    }

    public function profile()
    {
        $user = Auth::user();
        $reseller = Reseller::where('user_id', $user->id)->firstOrFail();
        return view('reseller.profile', compact('user', 'reseller'));
    }

    public function updateProfile(Request $request)
    {
        $user = Auth::user();
        $reseller = Reseller::where('user_id', $user->id)->firstOrFail();

        $request->validate([
            'phone' => 'required|string',
            'company_name' => 'nullable|string',
            'gst_number' => 'nullable|string',
            'address' => 'required|string',
            'city' => 'required|string',
            'state' => 'required|string',
            'pincode' => 'required|string',
            'logo' => 'nullable|image|max:2048',
        ]);

        // Update User Phone if needed (optional, assuming user table has phone)
        // $user->update(['phone' => $request->phone]);

        $data = $request->only(['company_name', 'gst_number', 'phone', 'address', 'city', 'state', 'pincode']);

        if ($request->hasFile('logo')) {
            if ($reseller->logo_path) {
                Storage::disk('public')->delete($reseller->logo_path);
            }
            $data['logo_path'] = $request->file('logo')->store('resellers/logos', 'public');
        }

        $reseller->update($data);

        return back()->with('success', 'Profile updated successfully.');
    }
}
