<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class PageController extends Controller
{
    public function show($slug)
    {
        $page = \App\Models\Page::where('slug', $slug)->firstOrFail();
        return view('pages.show', compact('page'));
    }

    public function contact()
    {
        $stores = \App\Models\Store::where('is_active', true)->get();
        return view('pages.contact', compact('stores'));
    }

    public function storeContact(\Illuminate\Http\Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'phone' => 'nullable|string|max:20',
            'subject' => 'required|string|max:255',
            'message' => 'required|string',
        ]);

        \App\Models\Contact::create($request->all());

        return back()->with('success', 'Your message has been sent successfully! We will get back to you soon.');
    }
}
