<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class BlogController extends Controller
{
    public function index(Request $request)
    {
        $blogs = \App\Models\BlogPost::where('status', 'published')
            ->latest('published_at')
            ->paginate(100);

        if ($request->ajax()) {
            $view = view('shop.blog.partials.item', compact('blogs'))->render();
            return response()->json([
                'html' => $view,
                'hasMore' => $blogs->hasMorePages()
            ]);
        }

        return view('shop.blog.index', compact('blogs'));
    }

    public function show($slug)
    {
        $blog = \App\Models\BlogPost::where('slug', $slug)
            ->where('status', 'published')
            ->firstOrFail();

        // Fetch recent post for sidebar or "More like this"
        $recentBlogs = \App\Models\BlogPost::where('status', 'published')
            ->where('id', '!=', $blog->id)
            ->latest('published_at')
            ->take(3)
            ->get();

        return view('shop.blog.show', compact('blog', 'recentBlogs'));
    }
}
