<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Order;
use App\Models\DeliveryAgent;

class DeliveryAgentDashboardController extends Controller
{
    public function index(Request $request)
    {
        $user = $request->user();

        // Ensure user is delivery agent just in case middleware missed it or for safety
        if (!$user->hasRole('delivery_agent')) {
            return response()->json(['message' => 'Access denied'], 403);
        }

        $agent = DeliveryAgent::where('user_id', $user->id)->first();

        if (!$agent) {
            return response()->json(['message' => 'Delivery Agent profile not found'], 404);
        }

        // Stats
        $newOrders = Order::where('delivery_agent_id', $agent->id)->whereIn('status', ['pending', 'processing'])->count();
        $inTransit = Order::where('delivery_agent_id', $agent->id)->where('status', 'shipped')->count();
        $completed = Order::where('delivery_agent_id', $agent->id)->where('status', 'completed')->count();
        $cancelled = Order::where('delivery_agent_id', $agent->id)->where('status', 'cancelled')->count();

        $cashCollected = Order::where('delivery_agent_id', $agent->id)
            ->where('status', 'completed')
            ->where('payment_method', 'cod')
            ->sum('total');

        $codOrderCount = Order::where('delivery_agent_id', $agent->id)
            ->where('status', 'completed')
            ->where('payment_method', 'cod')
            ->count();

        $unreadNotifications = $user->unreadNotifications->count();

        return response()->json([
            'agent' => $agent,
            'stats' => [
                'new_orders_count' => $newOrders,
                'in_transit_count' => $inTransit,
                'completed_count' => $completed,
                'cancelled_count' => $cancelled,
                'cash_collected' => $cashCollected,
                'cod_orders_count' => $codOrderCount,
                'unread_notifications_count' => $unreadNotifications,
            ]
        ]);
    }
}
