<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class CustomerWalletController extends Controller
{
    /**
     * Get wallet balance and transaction history.
     */
    public function index(Request $request)
    {
        $user = $request->user();

        // Fetch transactions paginated
        $transactions = $user->walletTransactions()
            ->latest()
            ->paginate(20)
            ->through(function ($txn) {
                return [
                    'id' => $txn->id,
                    'type' => $txn->type, // credit / debit
                    'amount' => $txn->amount, // Raw value
                    'description' => $txn->description,
                    'reference_type' => $txn->reference_type,
                    'reference_id' => $txn->reference_id,
                    'created_at' => $txn->created_at->toIso8601String(),
                    'formatted_amount' => '₹' . number_format($txn->amount, 2), // Assuming amount is stored as Rupee or handling it as is. If stored as paise, divide by 100.
                    // Based on migrations, it's integer. Usually for ecommerce in India, if it's integer it might be paise, or just rupees.
                    // Checking other controllers might clarify, but usually it's safer to send raw and let frontend format, or send both.
                    // For now assuming it is stored as Rupees based on simple internet shop conventions unless stripe/razorpay usage implies paise. 
                    // Let's stick to returning raw and a standard formatted string.
                ];
            });

        return response()->json([
            'wallet_balance' => $user->wallet_balance,
            'formatted_balance' => '₹' . number_format($user->wallet_balance, 2),
            'transactions' => $transactions
        ]);
    }
}
